/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime;

import filenet.vw.api.VWMilestoneDefinition;
import filenet.vw.api.VWMilestoneElement;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkMap;
import filenet.vw.toolkit.runtime.VWTrkStep;
import java.util.Date;
import java.util.Vector;

public class VWTrkMilestone {
    private VWTrkDataModel m_dataModel = null;
    private VWMilestoneDefinition m_definition = null;
    private int m_id = -1;
    protected Vector m_history = null;

    public VWTrkMilestone(VWTrkDataModel dataModel, VWMilestoneDefinition definition, int id) {
        this.m_dataModel = dataModel;
        if (definition != null) {
            this.m_definition = definition;
            this.m_id = id;
        }
    }

    public void addMilestoneElement(VWMilestoneElement element) {
        if (this.m_history == null) {
            this.m_history = new Vector();
        }
        this.m_history.addElement(element);
    }

    public String getName() {
        if (this.m_definition != null) {
            return this.m_definition.getName();
        }
        return null;
    }

    public int getId() {
        return this.m_id;
    }

    public int getLevel() {
        return this.m_definition.getLevel();
    }

    public String getMessage() {
        return this.m_definition.getMessage();
    }

    public Vector getHistory() {
        return this.m_history;
    }

    public boolean isReached() {
        return this.m_history != null;
    }

    public int getHistorySize() {
        if (this.m_history != null) {
            return this.m_history.size();
        }
        return 0;
    }

    private VWMilestoneElement getMilestoneElement(int i) {
        if (i == -1 && this.m_history != null) {
            i = this.m_history.size() - 1;
        }
        if (this.m_history != null && i >= 0 && i < this.m_history.size()) {
            return (VWMilestoneElement)this.m_history.elementAt(i);
        }
        return null;
    }

    public String getMessage(int i) {
        VWMilestoneElement element = this.getMilestoneElement(i);
        if (element != null) {
            return element.getMessage();
        }
        return null;
    }

    public Date getDate(int index) {
        VWMilestoneElement element = this.getMilestoneElement(index);
        if (element != null) {
            return element.getTimestamp();
        }
        return null;
    }

    public String getReachedMapName(int i) {
        VWMilestoneElement element = this.getMilestoneElement(i);
        if (element != null) {
            return element.getInstructionSheetName();
        }
        return null;
    }

    public String getReachedStepName(int i) {
        VWTrkStep step = this.getReachedStep(i);
        if (step != null) {
            return step.getStepName();
        }
        return null;
    }

    public VWTrkStep getReachedStep(int i) {
        VWMilestoneElement element = this.getMilestoneElement(i);
        if (element != null) {
            VWTrkMap map;
            int mapId = element.getInstructionSheetId();
            int stepId = element.getStepId();
            if (this.m_dataModel != null && (map = this.m_dataModel.getMap(mapId)) != null) {
                return map.findStep(stepId);
            }
        }
        return null;
    }

    public void removeReferences() {
        this.m_dataModel = null;
        this.m_definition = null;
        if (this.m_history != null) {
            this.m_history.removeAllElements();
            this.m_history = null;
        }
    }
}

